﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Reversi
{
    public partial class Form1 : Form
    {
        private Button[,] plansza = new Button[ReversiSilnikAI.planszaSzer, ReversiSilnikAI.planszaWys];
        private ReversiSilnikAI silnik = new ReversiSilnikAI();
        private Color[] kolory = { Color.Ivory, Color.Green, Color.Sienna, Color.Black };

        private bool graPrzeciwkoKomputerowi = true; //komputer ma numer 2 i gra brązowymi
        
        private bool pokazPriorytety = false;
        private bool panelZminimalizowany = true;        
        private Rectangle rozmiarOkna = Rectangle.Empty;

        private void ustalRozmiarPlanszy(bool tworzPrzyciski)
        {
            rozmiarOkna = this.ClientRectangle;

            //ustalanie rozmiaru przycisku
            int rozmiarPlanszy = Math.Min(rozmiarOkna.Width, rozmiarOkna.Height);
            int przyciskSzer = rozmiarPlanszy / ReversiSilnikAI.planszaSzer;
            int przyciskWys = rozmiarPlanszy / ReversiSilnikAI.planszaWys;

            //linkLabel1.Top = panel1.ClientSize.Height - linkLabel1.Height - 10;

            for (int i = 0; i < ReversiSilnikAI.planszaSzer; i++)
                for (int j = 0; j < ReversiSilnikAI.planszaWys; j++)
                {
                    if (tworzPrzyciski)
                    {
                        Button pole = new Button();
                        //pole.SetBounds(i * przyciskSzer, 1 + j * przyciskWys, przyciskSzer, przyciskWys);
                        pole.Bounds = new Rectangle(i * przyciskSzer, 1 + j * przyciskWys, przyciskSzer, przyciskWys);
                        pole.Parent = this;
                        pole.Click += new System.EventHandler(this.kliknieciePolaPlanszy);
                        plansza[i, j] = pole;
                    }
                    else
                    {
                        if (plansza[i, j] == null) return;
                        plansza[i, j].Bounds = new Rectangle(i * przyciskSzer, 1 + j * przyciskWys, przyciskSzer, przyciskWys);
                    }
                }
        }

        public Form1()
        {
            InitializeComponent();
            
            ustalRozmiarPlanszy(true);
            uzgodnijWygladPlanszy();

            panelZminimalizowany = true;
            ustalRozmiarPanelu();
        }

        #region Metody pomocnicze
        private void uzgodnijWygladPlanszy()
        {
            for (int i = 0; i < ReversiSilnikAI.planszaSzer; i++)
                for (int j = 0; j < ReversiSilnikAI.planszaWys; j++)
                {
                    //plansza[i,j].Text=silnik.StanPola(i,j).ToString();
                    //plansza[i,j].BackColor=kolory[silnik.StanPola(i,j)];
                    plansza[i, j].BackColor = kolory[silnik[i, j]];
                    if(pokazPriorytety) plansza[i,j].Text="";
                }

            //this.Text="Następny ruch gracz nr "+silnik.NumerGraczaWykonujacegoNastepnyRuch();
            button1.BackColor = kolory[silnik.NumerGraczaWykonujacegoNastepnyRuch()];
        }

        private void ustawieniePlanszyOdNowa()
        {
            silnik = new ReversiSilnikAI(); //stary obiekt zostanie automatycznie usuniety
            listBox1.Items.Clear();
            listBox2.Items.Clear();
            label1.Text = "2";
            label2.Text = "2";
            uzgodnijWygladPlanszy();
        }

        private void ruchKomputera()
        {
            int[] wspolrzedne = silnik.ProponujNajlepszyRuch();
            kliknieciePolaPlanszy(plansza[wspolrzedne[0], wspolrzedne[1]], null);
        }

        //************************************//
        // GŁÓWNA METODA "RZĄDZĄCA" PROGRAMEM //
        //************************************//
        private void kliknieciePolaPlanszy(object sender, EventArgs e)
        {
            //szukamy pola planszy odpowiadającego kliknietemu przyciskowi
            int kliknietePoziomo = -1, kliknietePionowo = -1;
            for (int poziomo = 0; poziomo < ReversiSilnikAI.planszaSzer; poziomo++)
                for (int pionowo = 0; pionowo < ReversiSilnikAI.planszaWys; pionowo++)
                    if (sender == plansza[poziomo, pionowo])
                    {
                        kliknietePoziomo = poziomo;
                        kliknietePionowo = pionowo;
                    }

            //jezeli nie znaleziony - zglaszanie bledu
            if (kliknietePoziomo == -1 || kliknietePionowo == -1)
                throw new Exception("Nie zidentyfikowane pole planszy");

            //wykonanie ruchu
            int zapamietanyNumerGracza = silnik.NumerGraczaWykonujacegoNastepnyRuch();
            if (silnik.UstawPionek(kliknietePoziomo, kliknietePionowo))
            {
                uzgodnijWygladPlanszy();
                //listBox1.Items.Add(""+zapamietanyNumerGracza+": "+kliknietePoziomo+", "+kliknietePionowo);
                switch (zapamietanyNumerGracza)
                {
                    case 1: listBox1.Items.Add(ReversiSilnikAI.SymbolPola(kliknietePoziomo, kliknietePionowo)); break;
                    case 2: listBox2.Items.Add(ReversiSilnikAI.SymbolPola(kliknietePoziomo, kliknietePionowo)); break;
                }
                listBox1.SelectedIndex = listBox1.Items.Count - 1;
                listBox2.SelectedIndex = listBox2.Items.Count - 1;
            }

            //sprawdzenie czy gra zakonczona
            int[] zliczenia = new int[3];
            int koniec_kod = silnik.CzyKoniec(zliczenia);
            label1.Text = zliczenia[1].ToString();
            label2.Text = zliczenia[2].ToString();
            if (koniec_kod == 2) MessageBox.Show("Obaj gracze nie mogą wykonać ruchu");
            if (koniec_kod > 0)
            {
                //informacja o wygranym
                MessageBox.Show("Wygrał gracz " + ((zliczenia[1] > zliczenia[2]) ? "zielony" : "brązowy"), "Reversi");
                if (MessageBox.Show("Czy rozpocząć grę od nowa?", "Reversi", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button1) == DialogResult.Yes)
                {
                    //rozpoczecie gry od nowa
                    ustawieniePlanszyOdNowa();
                }
                else
                {
                    this.Close();
                }
                return;
            }


            //sprawdzenie czy kolejny gracz ma mozliwosc ruchu
            if (!silnik.CzyMozliwyRuch())
            {
                MessageBox.Show("Gracz " + ((silnik.NumerGraczaWykonujacegoNastepnyRuch() == 1) ? "zielony" : "brązowy") + " zmuszony jest do oddania ruchu");
                silnik.Pass();
                uzgodnijWygladPlanszy();
                //jezeli komputer, to nie powinno byc return
                //(komputer zawsze brązowy)
                if (!(graPrzeciwkoKomputerowi && silnik.NumerGraczaWykonujacegoNastepnyRuch() == 2)) return;
            }

            //Ruch komputera (gracz nr 2)
            if (graPrzeciwkoKomputerowi && silnik.NumerGraczaWykonujacegoNastepnyRuch() == 2)
            {                
                //ruchKomputera();
                timer1.Enabled = true; //tam jest wywolywany ruch komputera z jednosekundowym opoznieniem
            }
        }
        #endregion

        private void menuItem11_Click(object sender, EventArgs e)
        {
            MessageBox.Show(
            "W grze Reversi gracze zajmują na przemian pola planszy przejmując przy tym wszystkie pola przeciwnika znajdujące się między nowo zajętym polem, a innymi polami gracza wykonującego ruch. Celem gry jest zdobycie większej ilości pól niż przeciwnik.\n" +
            "Gracz może zająć jedynie takie pole, które pozwoli mu przejąć przynajmniej jedno pole przeciwnika. Jeżeli takiego pola nie ma, musi oddać ruch.\n" +
            "Gra kończy się w momencie zajęcia wszystkich pól lub gdy żaden z graczy nie może wykonać ruchu.\n",
            "Reversi - Zasady gry");
        }

        private void menuItem12_Click(object sender, EventArgs e)
        {
            MessageBox.Show(
            "Komputer kieruje się następującymi priorytetami (od najwyższego):\n" +
            "1. Ustawić pionek w rogu.\n" +
            "2. Unikać ustawienia pionka tuż przy rogu.\n" +
            "3. Ustawić pionek przy krawędzi planszy.\n" +
            "4. Unikać ustawienia pionka w wierszu lub kolumnie oddalonej o jedno pole od krawędzi planszy.\n" +
            "5. Wybierać pole, w wyniku którego zdobyta zostanie największa liczba pól przeciwnika.\n",
            "Reversi - Strategia komputera");
        }

        private void menuItem14_Click(object sender, EventArgs e)
        {
            Version wersja = System.Reflection.Assembly.GetExecutingAssembly().GetName().Version;
            MessageBox.Show("Reversi Mobile\nwersja " + wersja.Major.ToString() + "." + wersja.Minor.ToString() + "." + wersja.Build.ToString() + "." + wersja.Revision.ToString() + "\n(c) Jacek Matulewski 2004,2009\n\nTesty:\nKazimierz Matulewski\nMonika Pogodzińska\n\nNajnowszą wersję można pobrać ze strony\nhttp://www.fizyka.umk.pl/~jacek/download/", "Reversi - Informacje o programie");
        }

        private void menuItem7_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void menuItem9_Click(object sender, EventArgs e)
        {
            int[] wspolrzedne = silnik.ProponujNajlepszyRuch();

            Color kolorGracza = (silnik.NumerGraczaWykonujacegoNastepnyRuch() == 1) ? Color.Green : Color.Sienna;
            Color kolorTla = Color.Ivory;

            if (pokazPriorytety)
            {
                int redP = (kolorGracza.R + 3 * kolorTla.R) / 4;
                int greenP = (kolorGracza.G + 3 * kolorTla.G) / 4;
                int blueP = (kolorGracza.B + 3 * kolorTla.B) / 4;
                Color kolorMozliwychRuchow = Color.FromArgb(redP, greenP, blueP);

                for (int i = 0; i < ReversiSilnikAI.planszaSzer; i++)
                    for (int j = 0; j < ReversiSilnikAI.planszaWys; j++)
                    {
                        long priorytet = silnik.planszaPriorytety[i, j];
                        plansza[i, j].Text = priorytet.ToString();
                        if (priorytet != 0) plansza[i, j].BackColor = kolorMozliwychRuchow;
                    }
            }

            //kolorPodpowiedzi
            int red = (kolorGracza.R + kolorTla.R) / 2;
            int green = (kolorGracza.G + kolorTla.G) / 2;
            int blue = (kolorGracza.B + kolorTla.B) / 2;
            Color kolorPodpowiedzi = Color.FromArgb(red, green, blue);

            plansza[wspolrzedne[0], wspolrzedne[1]].BackColor = kolorPodpowiedzi;
        }

        private void menuItem10_Click(object sender, EventArgs e)
        {
            ruchKomputera();
        }

        private void menuItem3_Click(object sender, EventArgs e)
        {
            graPrzeciwkoKomputerowi = true;
            ustawieniePlanszyOdNowa();
            this.Text = "Reversi - 1 gracz";

            //Ruch wykonuje komputer
            silnik.Pass();
            ruchKomputera(); //oddaje pierwszy ruch komputerowi
        }

        private void menuItem4_Click(object sender, EventArgs e)
        {
            graPrzeciwkoKomputerowi = true;
            ustawieniePlanszyOdNowa();
            this.Text = "Reversi - 1 gracz";
        }

        private void menuItem5_Click(object sender, EventArgs e)
        {
            graPrzeciwkoKomputerowi = false;
            ustawieniePlanszyOdNowa();
            this.Text = "Reversi - 2 graczy";
        }

        /*
        private void menuItem15_Click(object sender, EventArgs e)
        {
            pokazPriorytety = !pokazPriorytety;
            silnik.pokazPriorytety = pokazPriorytety;
            menuItem15.Checked = pokazPriorytety;
        }
        */

        private void ustalRozmiarPanelu()
        {
            bool panelPionowy = rozmiarOkna.Width < rozmiarOkna.Height;

            //przycisk w lewym gornym rogu panelu
            button1.Left = 3;
            button1.Top = 3;
            button1.Width = 24;
            button1.Height = 20;

            pictureBox1.Visible = false;
            pictureBox2.Visible = false;
            pictureBox3.Visible = false;
            pictureBox4.Visible = false;

            if (panelPionowy) //okno pionowe
            {
                panel1.Width = rozmiarOkna.Width;

                label3.Top = 5; label3.Left = 43; label3.Text = "Zielony"; //etykieta "Zielony"
                label1.Top = 5; label1.Left = 93;
                label4.Top = 5; label4.Left = 118; label4.Text = "Brązowy"; //etykieta "Brązowy"
                label2.Top = 5; label2.Left = 181;

                pictureBox1.Top = 4;
                pictureBox1.Left = panel1.Width - (int)(1.2 * pictureBox1.Width);
                pictureBox2.Top = 4;
                pictureBox2.Left = panel1.Width - (int)(1.2 * pictureBox2.Width);

                if (panelZminimalizowany)
                {
                    //panel zminimalizowany
                    Button dolnyPrzycisk = plansza[ReversiSilnikAI.planszaSzer - 1, ReversiSilnikAI.planszaWys - 1];
                    int dolnaKrawedzPlanszy = dolnyPrzycisk.Top + dolnyPrzycisk.Height;
                    panel1.Height = rozmiarOkna.Height - dolnaKrawedzPlanszy;
                    panel1.Top = dolnaKrawedzPlanszy;
                    panel1.Left = 0;
                    panel1.Width = rozmiarOkna.Width;

                    if (panel1.Height < 150)
                    {
                        pictureBox1.Visible = true;
                        pictureBox2.Visible = false;
                    }
                }
                else
                {
                    //panel powiekszony
                    panel1.Width = rozmiarOkna.Width;
                    panel1.Top = 150;
                    panel1.Height = rozmiarOkna.Height - panel1.Top;
                    panel1.Left = 0;

                    pictureBox1.Visible = false;
                    pictureBox2.Visible = true;
                }

                int h = 2 * button1.Top + button1.Height;
                if (panel1.Height > 2 * h)
                {
                    listBox1.Visible = true;
                    listBox2.Visible = true;

                    listBox1.Left = label3.Left;
                    listBox1.Top = h;
                    listBox1.Height = panel1.Height - listBox1.Top - h / 2;
                    listBox2.Left = label4.Left;
                    listBox2.Top = listBox1.Top;
                    listBox2.Height = listBox1.Height;
                    listBox1.Width = 66;
                    listBox2.Width = listBox1.Width;
                }
                else
                {
                    listBox1.Visible = false;
                    listBox2.Visible = false;
                }
            }
            else //okno poziome
            {
                int szerokoscPaneluPowiekszonego = 150;
                panel1.Height = rozmiarOkna.Height;

                label3.Left = 5; label3.Top = 43; label3.Text = "Ziel."; //etykieta "Zielony"
                label1.Left = 5; label1.Top = label3.Top + 20;
                int dolnaKrawedzPrzycisku = button1.Top + button1.Height;
                label4.Left = 5; label4.Top = dolnaKrawedzPrzycisku + (panel1.Height - (dolnaKrawedzPrzycisku)) / 2; label4.Text = "Brąz."; //etykieta "Brązowy"
                label2.Left = 5; label2.Top = label4.Top + 20;

                pictureBox3.Left = 5;
                pictureBox3.Top = panel1.Height - (int)(1.2 * pictureBox1.Height);
                pictureBox4.Left = 5;
                pictureBox4.Top = panel1.Height - pictureBox2.Height;

                if (panelZminimalizowany)
                {
                    //panel zminimalizowany
                    Button prawyPrzycisk = plansza[ReversiSilnikAI.planszaSzer - 1, ReversiSilnikAI.planszaWys - 1];
                    int prawaKrawedzPlanszy = prawyPrzycisk.Left + prawyPrzycisk.Width;
                    panel1.Width = rozmiarOkna.Width - prawaKrawedzPlanszy;
                    panel1.Left = prawaKrawedzPlanszy;
                    panel1.Top = 0;

                    if (panel1.Width < szerokoscPaneluPowiekszonego)
                    {
                        pictureBox3.Visible = true;
                        pictureBox4.Visible = false;
                    }
                }
                else
                {
                    //panel powiekszony
                    panel1.Left = rozmiarOkna.Width-szerokoscPaneluPowiekszonego;
                    panel1.Width = rozmiarOkna.Width - panel1.Left;                    
                    panel1.Height = rozmiarOkna.Height;
                    panel1.Top = 0;

                    pictureBox3.Visible = false;
                    pictureBox4.Visible = true;
                }

                int h = 2 * button1.Top + button1.Height;
                int w = 2 * button1.Left + button1.Width;
                if (panel1.Height > 2 * h && panel1.Width > 3 * w)
                {
                    listBox1.Visible = true;
                    listBox2.Visible = true;

                    listBox1.Left = (int)(1.5 * w);
                    listBox1.Top = label3.Top;
                    listBox2.Left = listBox1.Left;
                    listBox2.Top = label4.Top;

                    listBox1.Height = listBox2.Top - listBox1.Top - h / 2;
                    listBox2.Height = listBox1.Height;
                    listBox1.Width = panel1.Width - listBox1.Left - w / 2;
                    listBox2.Width = listBox1.Width;
                }
                else
                {
                    listBox1.Visible = false;
                    listBox2.Visible = false;
                }
            }
        }


        private void pictureBox1_Click(object sender, EventArgs e)
        {
            panelZminimalizowany = !panelZminimalizowany;
            ustalRozmiarPanelu();
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            timer1.Enabled = false;
            if (silnik.CzyKoniec(null) == 0) ruchKomputera();
        }

        private void Form1_Resize(object sender, EventArgs e)
        {
            if (rozmiarOkna == Rectangle.Empty || plansza == null) return;            
            ustalRozmiarPlanszy(false);
            ustalRozmiarPanelu();
        }
    }
}